PXCAPED ;ISL/dee - Validates & Translates data from the PCE Device Interface into PCE's PXK format for Patient Ed ;3/14/97
 ;;1.0;PCE PATIENT CARE ENCOUNTER;**27**;Aug 12, 1996
 Q
 ; Variables
 ;   PXCAPED  Copy of a PATIENT ED node of the PXCA array
 ;   PXCAPRV   Pointer to the provider (200)
 ;   PXCANUMB  Count of the number if PEDs
 ;   PXCAINDX  Count of the number of PATIENT ED for one provider
 ;   PXCAPNAR  Pointer to the provider narrative (9999999.27)
 ;
PED(PXCAPED,PXCANUMB,PXCAPRV,PXCAERRS) ;
 S ^TMP(PXCAGLB,$J,"PED",PXCANUMB,"IEN")=""
 S ^TMP(PXCAGLB,$J,"PED",PXCANUMB,0,"BEFORE")=""
 S ^TMP(PXCAGLB,$J,"PED",PXCANUMB,0,"AFTER")=$P(PXCAPED,"^",1)_"^"_PXCAPAT_"^"_PXCAVSIT_"^^^"_$P(PXCAPED,"^",2)
 S ^TMP(PXCAGLB,$J,"PED",PXCANUMB,12,"BEFORE")=""
 S ^TMP(PXCAGLB,$J,"PED",PXCANUMB,12,"AFTER")="^^^"_$S(PXCAPRV>0:PXCAPRV,1:"")
 S ^TMP(PXCAGLB,$J,"PED",PXCANUMB,812,"BEFORE")=""
 S ^TMP(PXCAGLB,$J,"PED",PXCANUMB,812,"AFTER")="^"_PXCAPKG_"^"_PXCASOR
 Q
 ;
PATED(PXCA,PXCABULD,PXCAERRS) ;Validation routine for PED
 Q:'$D(PXCA("PATIENT ED"))
 N PXCAPED,PXCAPRV,PXCANUMB,PXCAINDX
 N PXCAITEM
 S PXCAPRV=""
 S PXCANUMB=0
 F  S PXCAPRV=$O(PXCA("PATIENT ED",PXCAPRV)) Q:PXCAPRV']""  D
 . I PXCAPRV>0 D
 .. I '$$ACTIVPRV^PXAPI(PXCAPRV,PXCADT) S PXCA("ERROR","PATIENT ED",PXCAPRV,0,0)="Provider is not active or valid^"_PXCAPRV
 .. E  I PXCABULD!PXCAERRS D ANOTHPRV^PXCAPRV(PXCAPRV)
 . S PXCAINDX=""
 . F  S PXCAINDX=$O(PXCA("PATIENT ED",PXCAPRV,PXCAINDX)) Q:PXCAINDX']""  D
 .. S PXCAPED=$G(PXCA("PATIENT ED",PXCAPRV,PXCAINDX))
 .. S PXCANUMB=PXCANUMB+1
 .. I PXCAPED="" S PXCA("ERROR","PATIENT ED",PXCAPRV,PXCAINDX,0)="PATIENT ED data missing" Q
 .. S PXCAITEM=+$P(PXCAPED,U,1)
 .. I $G(^AUTTEDT(PXCAITEM,0))="" S PXCA("ERROR","PATIENT ED",PXCAPRV,PXCAINDX,1)="PATIENT ED type not in file 9999999.09^"_PXCAITEM
 .. S PXCAITEM=$P(PXCAPED,U,2) I '((PXCAITEM=(PXCAITEM\1)&(PXCAITEM>0)&(PXCAITEM<6))!(PXCAITEM="")) S PXCA("ERROR","PATIENT ED",PXCAPRV,PXCAINDX,2)="PATIENT ED level of understanding must be an integer form 1 to 5^"_PXCAITEM
 .. I PXCABULD&'$D(PXCA("ERROR","PATIENT ED",PXCAPRV,PXCAINDX))!PXCAERRS D PED(PXCAPED,.PXCANUMB,PXCAPRV,PXCAERRS)
 Q
 ;
